def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato1' to interact with
        if 'tomato1' in positions:
            tomato_pos = positions['tomato1']
        else:
            print("Error: 'tomato1' not found in the environment.")
            return

        # Move to the location of the tomato
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato_pos)
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Pick the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato1', obs.robot_position)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Move to a designated drop location (assuming it's defined)
        drop_location = (1, 1, 0)  # Example drop location
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, task, obs.robot_position, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Place the tomato down
        print("[Task] Placing the tomato down.")
        obs, reward, done = place(env, 'tomato1', drop_location)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()