def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato' in the environment
        tomato_pos = positions['tomato']
        switch_pos = positions['switch']  # Assuming there's a switch to press

        # Step 1: Move to the tomato's position
        print("[Task] Moving to the tomato's position:", tomato_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato_pos)
        if done:
            print("[Task] Task ended after moving to the tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking the tomato.")
        obs, reward, done = pick(env, 'tomato', obs.robot_position)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the switch's position
        print("[Task] Moving to the switch's position:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 4: Close the gripper to ensure the tomato is held
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 5: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 6: Place the tomato back down (if needed)
        print("[Task] Placing the tomato back down.")
        obs, reward, done = place(env, 'tomato', obs.robot_position)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()