def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a plate and a robot
        plate_pos = positions['plate']
        robot_pos = positions['robot']

        # Move to the plate's position
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, robot_pos, plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Close the gripper
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Pick the plate
        print("[Task] Picking the plate.")
        obs, reward, done = pick(env, 'plate', plate_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Move to a new location (e.g., disposal area)
        disposal_area_pos = positions['disposal_area']
        print("[Task] Moving to the disposal area at:", disposal_area_pos)
        obs, reward, done = move(env, plate_pos, disposal_area_pos)
        if done:
            print("[Task] Task ended after moving to the disposal area!")
            return

        # Place the plate in the disposal area
        print("[Task] Placing the plate in the disposal area.")
        obs, reward, done = place(env, 'plate', disposal_area_pos)
        if done:
            print("[Task] Task ended after placing the plate!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()