def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        plate_pos = positions['plate']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to the plate
        print("[Task] Moving to the plate at:", plate_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=plate_pos)
        if done:
            print("[Task] Task ended after moving to the plate!")
            return

        # Step 2: Pick the plate
        print("[Task] Picking the plate.")
        obs, reward, done = pick(env, 'plate', plate_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking the plate!")
            return

        # Step 3: Move to item1
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 4: Place item1
        print("[Task] Placing item1.")
        obs, reward, done = place(env, 'item1', item1_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 5: Move to item2
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 6: Pick item2
        print("[Task] Picking item2.")
        obs, reward, done = pick(env, 'item2', item2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 7: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 8: Place item2 in the bin
        print("[Task] Placing item2 in the bin.")
        obs, reward, done = place(env, 'item2', bin_pos)
        if done:
            print("[Task] Task ended after placing item2 in the bin!")
            return

        # Step 9: Move to item3
        print("[Task] Moving to item3 at:", item3_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=item3_pos)
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        # Step 10: Pick item3
        print("[Task] Picking item3.")
        obs, reward, done = pick(env, 'item3', item3_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 11: Move to the bin
        print("[Task] Moving to the bin at:", bin_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 12: Place item3 in the bin
        print("[Task] Placing item3 in the bin.")
        obs, reward, done = place(env, 'item3', bin_pos)
        if done:
            print("[Task] Task ended after placing item3 in the bin!")
            return

        # Step 13: Move to the switch
        print("[Task] Moving to the switch at:", switch_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 14: Close the gripper
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 15: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, 'switch')
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()