def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and a room
        robot_position = positions['robot']
        object_position = positions['object']  # Replace with actual object key
        switch_position = positions['switch']  # Replace with actual switch key

        # Step 1: Move to the object
        print("[Task] Moving to the object at:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, 'object', object_position, 'gripper')
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the switch
        print("[Task] Moving to the switch at:", switch_position)
        obs, reward, done = move(env, object_position, switch_position)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 4: Close the gripper (if needed)
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 5: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_position)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 6: Place the object back (if needed)
        print("[Task] Placing the object back.")
        obs, reward, done = place(env, 'object', object_position)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()