import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        _, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        tomato1_pos = positions['item1']
        tomato2_pos = positions['tomato2']
        plate_pos = positions['plate']
        switch_pos = positions['switch']

        # Step 1: Close the gripper
        print("[Task] Closing gripper...")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 2: Press the switch to turn on the light
        print("[Task] Pressing the switch...")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 3: Pick the first tomato
        print("[Task] Picking the first tomato...")
        obs, reward, done = pick(env, task, tomato1_pos)
        if done:
            print("[Task] Task ended after picking the first tomato!")
            return

        # Step 4: Place the first tomato onto the plate
        print("[Task] Placing the first tomato onto the plate...")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task ended after placing the first tomato!")
            return

        # Step 5: Pick the second tomato
        print("[Task] Picking the second tomato...")
        obs, reward, done = pick(env, task, tomato2_pos)
        if done:
            print("[Task] Task ended after picking the second tomato!")
            return

        # Step 6: Place the second tomato onto the plate
        print("[Task] Placing the second tomato onto the plate...")
        obs, reward, done = place(env, task, plate_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")