def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'object1', 'object2', and 'switch'
        object1_pos = positions['object1']
        object2_pos = positions['object2']
        switch_pos = positions['switch']
        
        # Step 1: Move to object1
        print("[Task] Moving to object1 at:", object1_pos)
        obs, reward, done = move(env, task, 'room_a', 'room_b')  # Example rooms
        if done:
            print("[Task] Task ended after moving to object1!")
            return

        # Step 2: Pick object1
        print("[Task] Picking object1.")
        obs, reward, done = pick(env, 'object1', 'room_b', 'gripper')
        if done:
            print("[Task] Task ended after picking object1!")
            return

        # Step 3: Move to switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, 'room_b', 'room_c')  # Example rooms
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 5: Move to object2
        print("[Task] Moving to object2 at:", object2_pos)
        obs, reward, done = move(env, task, 'room_c', 'room_d')  # Example rooms
        if done:
            print("[Task] Task ended after moving to object2!")
            return

        # Step 6: Place object1 at object2's location
        print("[Task] Placing object1 at object2's location.")
        obs, reward, done = place(env, 'object1', 'room_d')
        if done:
            print("[Task] Task ended after placing object1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()