def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball and a room in the environment
        ball_pos = positions['ball']
        room_pos = positions['room']

        # Step 1: Move to the ball's location
        print("[Task] Moving to the ball's location:", ball_pos)
        obs, reward, done = move(env, task, from_room=room_pos, to_room=ball_pos)
        if done:
            print("[Task] Task ended after moving to the ball!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball at:", ball_pos)
        obs, reward, done = pick(env, task, obj='ball', room=room_pos, gripper='gripper')
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the disposal location (assuming it's a different room)
        disposal_room_pos = positions['disposal_room']
        print("[Task] Moving to the disposal location:", disposal_room_pos)
        obs, reward, done = move(env, task, from_room=ball_pos, to_room=disposal_room_pos)
        if done:
            print("[Task] Task ended after moving to the disposal location!")
            return

        # Step 4: Place the ball in the disposal location
        print("[Task] Placing the ball at:", disposal_room_pos)
        obs, reward, done = place(env, task, obj='ball', room=disposal_room_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()