def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a switch and a bin in the environment
        switch_pos = positions['switch']
        bin_pos = positions['bin']
        object_to_pick = 'rubbish'  # Example object to pick

        # Step 1: Move to the switch
        print("[Task] Moving to the switch.")
        obs, reward, done = move(env, task, 'current_room', 'switch_room')
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 2: Close the gripper to prepare for pressing
        print("[Task] Closing the gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing the gripper!")
            return

        # Step 3: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, task, switch_pos)
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 4: Move to the rubbish
        print("[Task] Moving to the rubbish.")
        obs, reward, done = move(env, task, 'current_room', 'rubbish_room')
        if done:
            print("[Task] Task ended after moving to the rubbish!")
            return

        # Step 5: Pick the rubbish
        print("[Task] Picking the rubbish.")
        obs, reward, done = pick(env, task, object_to_pick, 'rubbish_room')
        if done:
            print("[Task] Task ended after picking the rubbish!")
            return

        # Step 6: Move to the bin
        print("[Task] Moving to the bin.")
        obs, reward, done = move(env, task, 'rubbish_room', 'bin_room')
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 7: Place the rubbish in the bin
        print("[Task] Placing the rubbish in the bin.")
        obs, reward, done = place(env, task, object_to_pick, 'bin_room')
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()