def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are named 'tomato1', 'tomato2', and 'rubbish'
        tomato1_pos = positions.get('tomato1')
        tomato2_pos = positions.get('tomato2')
        rubbish_pos = positions.get('rubbish')

        # Check if the objects are present in the environment
        if tomato1_pos is None or tomato2_pos is None or rubbish_pos is None:
            print("[Task] One or more objects are not present in the environment.")
            return

        # Step 1: Move to tomato1
        print("[Task] Moving to tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=tomato1_pos)
        if done:
            print("[Task] Task ended after moving to tomato1!")
            return

        # Step 2: Pick tomato1
        print("[Task] Picking tomato1.")
        obs, reward, done = pick(env, task, obj='tomato1', room='room', gripper='gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Step 3: Move to rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 4: Place rubbish
        print("[Task] Placing rubbish.")
        obs, reward, done = place(env, task, obj='rubbish', room='room')
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

        # Step 5: Move to tomato2
        print("[Task] Moving to tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=tomato2_pos)
        if done:
            print("[Task] Task ended after moving to tomato2!")
            return

        # Step 6: Pick tomato2
        print("[Task] Picking tomato2.")
        obs, reward, done = pick(env, task, obj='tomato2', room='room', gripper='gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Step 7: Move to rubbish again
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 8: Place tomato2
        print("[Task] Placing tomato2.")
        obs, reward, done = place(env, task, obj='tomato2', room='room')
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()