def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name if different

        # Step 1: Pick the ball
        print("[Task] Picking the ball at:", ball_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=ball_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0,
            target_object='ball'  # Ensure we specify the target object
        )
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 2: Move to a new location (e.g., a drop-off point)
        drop_off_pos = positions['drop_off']  # Replace 'drop_off' with the actual drop-off location
        print("[Task] Moving to drop-off location:", drop_off_pos)
        obs, reward, done = move(env, task, current_location=ball_pos, target_location=drop_off_pos)
        if done:
            print("[Task] Task ended after moving to drop-off location!")
            return

        # Step 3: Place the ball at the drop-off location
        print("[Task] Placing the ball at:", drop_off_pos)
        obs, reward, done = place(
            env,
            task,
            target_pos=drop_off_pos
        )
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()