def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have an object named 'tomato' in the environment
        object_name = 'tomato'
        if object_name not in positions:
            raise ValueError(f"Object '{object_name}' not found in the environment.")

        object_pos = positions[object_name]
        robot_pos = positions['robot']  # Assuming the robot's position is also available

        # Step 1: Move to the object's location
        print(f"[Task] Moving to {object_name} at:", object_pos)
        obs, reward, done = move(env, robot_pos, object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print(f"[Task] Picking up {object_name}...")
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to a designated drop location (assuming it's defined)
        drop_location = positions['drop_zone']  # Assuming a drop zone is defined
        print(f"[Task] Moving to drop location at:", drop_location)
        obs, reward, done = move(env, object_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Step 4: Place the object down
        print(f"[Task] Placing down {object_name}...")
        obs, reward, done = place(env, task, target_pos=drop_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()