def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if target objects are available
        if 'tomato1' not in positions or 'tomato2' not in positions:
            print("Error: Target object not found in object list")
            return

        # Get positions of the target objects
        tomato1_pos = positions['tomato1']
        tomato2_pos = positions['tomato2']
        
        # Approach and pick tomato1
        print("[Task] Approaching and picking tomato1 at:", tomato1_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato1_pos)
        if done:
            print("[Task] Task ended while moving to tomato1!")
            return
        
        obs, reward, done = pick(env, 'tomato1', obs.robot_position, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato1!")
            return

        # Approach and place tomato1
        print("[Task] Placing tomato1 at the designated location.")
        obs, reward, done = move(env, task, obs.robot_position, 'designated_location')
        if done:
            print("[Task] Task ended while moving to designated location!")
            return
        
        obs, reward, done = place(env, 'tomato1', 'designated_location')
        if done:
            print("[Task] Task ended after placing tomato1!")
            return

        # Approach and pick tomato2
        print("[Task] Approaching and picking tomato2 at:", tomato2_pos)
        obs, reward, done = move(env, task, obs.robot_position, tomato2_pos)
        if done:
            print("[Task] Task ended while moving to tomato2!")
            return
        
        obs, reward, done = pick(env, 'tomato2', obs.robot_position, 'gripper')
        if done:
            print("[Task] Task ended after picking tomato2!")
            return

        # Approach and place tomato2
        print("[Task] Placing tomato2 at the designated location.")
        obs, reward, done = move(env, task, obs.robot_position, 'designated_location')
        if done:
            print("[Task] Task ended while moving to designated location!")
            return
        
        obs, reward, done = place(env, 'tomato2', 'designated_location')
        if done:
            print("[Task] Task ended after placing tomato2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()