def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a specific object to manipulate
        object_name = 'tomato2'
        object_pos = positions.get(object_name)

        if object_pos is None:
            print(f"[Task] {object_name} not found in the environment!")
            return

        # Move to the object's location
        print(f"[Task] Moving to {object_name} at:", object_pos)
        obs, reward, done = move(env, task, from_room='rooma', to_room='roomb')
        if done:
            print("[Task] Task ended after moving!")
            return

        # Close the gripper
        print("[Task] Closing gripper.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Pick the object
        print(f"[Task] Picking {object_name}.")
        obs, reward, done = pick(env, object_name, 'roomb', 'gripper')
        if done:
            print("[Task] Task ended after picking!")
            return

        # Move to the drop location (assuming it's 'roomc')
        print(f"[Task] Moving to drop location.")
        obs, reward, done = move(env, task, from_room='roomb', to_room='roomc')
        if done:
            print("[Task] Task ended after moving to drop location!")
            return

        # Place the object
        print(f"[Task] Placing {object_name}.")
        obs, reward, done = place(env, object_name, 'roomc')
        if done:
            print("[Task] Task ended after placing!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()