def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming the objects are 'rubbish' and 'switch' in the environment
        rubbish_pos = positions.get('rubbish')
        switch_pos = positions.get('switch')

        # Check if the objects are present
        if rubbish_pos is None or switch_pos is None:
            print("One or more required objects are missing in the environment.")
            return

        # Step 1: Move to the rubbish
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Close the gripper to pick up the rubbish
        print("[Task] Closing gripper to pick up rubbish.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 3: Pick up the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 4: Move to the switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 5: Close the gripper to press the switch
        print("[Task] Closing gripper to press the switch.")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 6: Press the switch
        print("[Task] Pressing the switch.")
        obs, reward, done = press(env, 'switch')
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 7: Move to the bin to drop the rubbish
        print("[Task] Moving to the bin to drop rubbish.")
        bin_pos = positions.get('bin')
        if bin_pos is None:
            print("Bin is missing in the environment.")
            return
        obs, reward, done = move(env, task, current_pos=obs.robot_position, target_pos=bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 8: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, 'rubbish', bin_pos)
        if done:
            print("[Task] Task ended after placing rubbish in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()