def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball object to pick and a room to place it in
        ball_pos = positions['ball']  # Replace 'ball' with the actual object name
        room_pos = positions['room']   # Replace 'room' with the actual room name

        # Check if the room is dark and handle accordingly
        if obs.dark:
            print("[Task] Room is dark, need to turn on the light first.")
            # Move to the switch and press it to turn on the light
            obs, reward, done = move(env, task, obs.robot_position, positions['switch'])  # Replace 'switch' with actual switch position
            if done:
                print("[Task] Task ended after moving to the switch!")
                return
            obs, reward, done = press(positions['switch'])  # Press the switch to turn on the light
            if done:
                print("[Task] Task ended after pressing the switch!")
                return

        # Now we can pick the ball
        print("[Task] Manipulating ball at:", ball_pos)
        obs, reward, done = pick(env, task, target_pos=ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Move to the room to place the ball
        print("[Task] Moving to room to place the ball.")
        obs, reward, done = move(env, task, obs.robot_position, room_pos)
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Place the ball in the room
        print("[Task] Placing the ball in the room.")
        obs, reward, done = place(env, task, target_pos=room_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()