def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to manipulate
        target_object = 'object_1'  # Replace with actual object name
        target_pos = positions[target_object]

        # Check if the target object is in the object list
        if target_object not in positions:
            print(f"Target object {target_object} not found in object list.")
            return

        # Move to the object's location
        print(f"[Task] Moving to {target_object} at:", target_pos)
        obs, reward, done = move(env, task, 'current_room', 'target_room')  # Replace with actual room names
        if done:
            print("[Task] Task ended during movement!")
            return

        # Pick the object
        print(f"[Task] Picking up {target_object} at:", target_pos)
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Move to a new location to place the object
        new_location = 'new_room'  # Replace with actual room name
        print(f"[Task] Moving to place {target_object} at:", new_location)
        obs, reward, done = move(env, task, 'target_room', new_location)
        if done:
            print("[Task] Task ended during movement!")
            return

        # Place the object
        print(f"[Task] Placing {target_object} at:", new_location)
        obs, reward, done = place(env, task, target_pos)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()