def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball and a room in the environment
        ball_pos = positions['ball']
        room_pos = positions['room']

        # Step 1: Move to the room where the ball is located
        print("[Task] Moving to the room to pick the ball.")
        obs, reward, done = move(env, task, from_room='initial_room', to_room='room')
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Check if the room is dark
        if obs.dark:
            print("[Task] The room is dark, closing the gripper to prepare for picking.")
            obs, reward, done = close_gripper(env, task)
            if done:
                print("[Task] Task ended after closing the gripper!")
                return

            # Step 3: Pick the ball
            print("[Task] Picking the ball.")
            obs, reward, done = pick(env, 'ball', 'room', 'gripper')
            if done:
                print("[Task] Task ended after picking the ball!")
                return

            # Step 4: Place the ball in a designated location
            print("[Task] Placing the ball in the designated location.")
            obs, reward, done = place(env, 'ball', 'designated_location')
            if done:
                print("[Task] Task ended after placing the ball!")
                return
        else:
            print("[Task] The room is not dark, proceeding to pick the ball directly.")
            obs, reward, done = pick(env, 'ball', 'room', 'gripper')
            if done:
                print("[Task] Task ended after picking the ball!")
                return

            # Step 4: Place the ball in a designated location
            print("[Task] Placing the ball in the designated location.")
            obs, reward, done = place(env, 'ball', 'designated_location')
            if done:
                print("[Task] Task ended after placing the ball!")
                return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()