def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick
        rubbish_pos = positions.get('rubbish')  # Replace 'rubbish' with the actual object name

        # Check if the rubbish object is available
        if rubbish_pos is None:
            print("[Task] Rubbish object not found in the environment.")
            return

        # Move to the location of the rubbish
        print("[Task] Moving to rubbish location:", rubbish_pos)
        obs, reward, done = move(env, task, obs.robot_position, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # Attempt to pick the rubbish
        print("[Task] Attempting to pick the rubbish.")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # Assuming we have a drop location
        drop_location = positions.get('drop_zone')  # Replace 'drop_zone' with the actual drop location name

        # Check if the drop location is available
        if drop_location is None:
            print("[Task] Drop location not found in the environment.")
            return

        # Move to the drop location
        print("[Task] Moving to drop location:", drop_location)
        obs, reward, done = move(env, task, obs.robot_position, drop_location)
        if done:
            print("[Task] Task ended while moving to drop location!")
            return

        # Attempt to place the rubbish
        print("[Task] Attempting to place the rubbish.")
        obs, reward, done = place(env, task, target_pos=rubbish_pos, location=drop_location)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()