def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and a room
        robot_position = positions['robot']
        object_position = positions['object']  # Replace 'object' with the actual object name

        # Step 1: Move to the object's location
        print("[Task] Moving to the object's location:", object_position)
        obs, reward, done = move(env, robot_position, object_position)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Step 2: Pick the object
        print("[Task] Picking the object at:", object_position)
        obs, reward, done = pick(env, 'object', object_position, 'gripper')  # Replace 'object' with the actual object name
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 3: Move to the disposal location (assuming disposal_location is defined)
        disposal_location = positions['disposal']  # Replace 'disposal' with the actual disposal location name
        print("[Task] Moving to the disposal location:", disposal_location)
        obs, reward, done = move(env, object_position, disposal_location)
        if done:
            print("[Task] Task ended after moving to the disposal location!")
            return

        # Step 4: Place the object
        print("[Task] Placing the object at:", disposal_location)
        obs, reward, done = place(env, task, disposal_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()