def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        object_1_pos = positions['item1']  # Replace with actual object names
        object_2_pos = positions['item2']  # Replace with actual object names
        switch_pos = positions['switch']    # Replace with actual object names
        bin_pos = positions['bin']          # Replace with actual object names

        # Step 1: Move to object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, task, from_room=obs.robot_location, to_room=object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object_1
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, task, obj='item1', room=object_1_pos, gripper='gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to switch
        print("[Task] Moving to switch at:", switch_pos)
        obs, reward, done = move(env, task, from_room=object_1_pos, to_room=switch_pos)
        if done:
            print("[Task] Task ended after moving to switch!")
            return

        # Step 4: Close gripper (if needed)
        print("[Task] Closing gripper")
        obs, reward, done = close_gripper(env, task)
        if done:
            print("[Task] Task ended after closing gripper!")
            return

        # Step 5: Press the switch
        print("[Task] Pressing the switch")
        obs, reward, done = press(env, task, sw='switch')
        if done:
            print("[Task] Task ended after pressing the switch!")
            return

        # Step 6: Move to bin
        print("[Task] Moving to bin at:", bin_pos)
        obs, reward, done = move(env, task, from_room=switch_pos, to_room=bin_pos)
        if done:
            print("[Task] Task ended after moving to bin!")
            return

        # Step 7: Place object_1 in the bin
        print("[Task] Placing object_1 in the bin")
        obs, reward, done = place(env, task, obj='item1', room=bin_pos)
        if done:
            print("[Task] Task ended after placing object_1 in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()