def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick and a location to place it
        rubbish_pos = positions['rubbish']  # Replace with actual object name
        drop_location = positions['drop_zone']  # Replace with actual drop zone name

        # Check if the rubbish object is present
        if 'rubbish' not in positions:
            raise ValueError("Rubbish object not in object list")

        # Implement force calibration check
        def is_force_calibrated():
            # Placeholder for actual force calibration logic
            return True  # Assume it's calibrated for now

        if not is_force_calibrated():
            raise ValueError("Force calibration not within safe limits")

        # Add safety checks
        def is_safety_clear():
            # Placeholder for actual safety check logic
            return True  # Assume it's safe for now

        if not is_safety_clear():
            raise ValueError("Safety not clear")

        # Move to the rubbish object
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, current_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Pick the rubbish
        print("[Task] Picking up rubbish.")
        obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)
        if done:
            print("[Task] Task ended after picking rubbish!")
            return

        # Move to the drop zone
        print("[Task] Moving to drop zone at:", drop_location)
        obs, reward, done = move(env, task, rubbish_pos, drop_location)
        if done:
            print("[Task] Task ended after moving to drop zone!")
            return

        # Place the rubbish
        print("[Task] Placing rubbish.")
        obs, reward, done = place(env, task, 'rubbish', drop_location)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()