def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a room and an object to manipulate
        room = 'rooma'  # Example room
        object_name = 'ball'  # Example object
        object_pos = positions[object_name]  # Get the position of the object

        # Check if the room is dark and handle accordingly
        if obs.dark:
            print("[Task] Room is dark, need to turn on the light.")
            # Move to the switch (assuming we have a switch in the environment)
            switch_pos = positions['switch']  # Get the position of the switch
            obs, reward, done = move(env, task, obs.robot_position, switch_pos)
            if done:
                print("[Task] Task ended while moving to the switch!")
                return
            
            # Close the gripper to press the switch
            obs, reward, done = pick(env, task, switch_pos)
            if done:
                print("[Task] Task ended while picking the switch!")
                return
            
            # Press the switch to turn on the light
            obs, reward, done = press(env, task, switch_pos)
            if done:
                print("[Task] Task ended while pressing the switch!")
                return

        # Now we can pick the object
        print("[Task] Manipulating object at:", object_pos)
        obs, reward, done = pick(env, task, target_pos=object_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Place the object somewhere (assuming we have a target location)
        target_location = 'roomb'  # Example target location
        obs, reward, done = place(env, task, target_pos=target_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()