import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        item1_pos = positions['item1']
        bin_pos = positions['bin']
        table_pos = positions['table']

        # === Task Plan Execution ===
        # Step 1: Pick item1 from the table
        print("[Task] Picking item1 from the table.")
        obs, reward, done = pick(env, task, item1_pos, table_pos)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 2: Place item1 into the bin
        print("[Task] Placing item1 into the bin.")
        obs, reward, done = place(env, task, 'item1', bin_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()