def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a robot and a location
        robot = 'robot'  # Placeholder for the robot identifier
        room = 'room'    # Placeholder for the room identifier
        object_1 = 'object_1'  # Placeholder for the first object
        object_2 = 'object_2'  # Placeholder for the second object

        # Step 1: Move to the first object
        print(f"[Task] Moving to {object_1} at {positions[object_1]}")
        obs, reward, done = move(env, robot, room, positions[object_1])
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick the first object
        print(f"[Task] Picking {object_1}")
        obs, reward, done = pick(env, object_1, room, 'gripper')
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the second object
        print(f"[Task] Moving to {object_2} at {positions[object_2]}")
        obs, reward, done = move(env, robot, room, positions[object_2])
        if done:
            print("[Task] Task ended after moving to object_2!")
            return

        # Step 4: Place the first object
        print(f"[Task] Placing {object_1} at {positions[object_2]}")
        obs, reward, done = place(env, object_1, positions[object_2])
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # Step 5: Complete the task
        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()