def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        ball_pos = positions['ball']
        switch_pos = positions['switch']
        bin_pos = positions['bin']

        # Step 1: Move to the ball's position
        print("[Task] Moving to the ball's position:", ball_pos)
        obs, reward, done = move(env, task, obs.robot_position, ball_pos)
        if done:
            print("[Task] Task ended after moving to the ball!")
            return

        # Step 2: Pick the ball
        print("[Task] Picking the ball...")
        obs, reward, done = pick(env, task, target_pos=ball_pos)
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 3: Move to the switch's position
        print("[Task] Moving to the switch's position:", switch_pos)
        obs, reward, done = move(env, task, obs.robot_position, switch_pos)
        if done:
            print("[Task] Task ended after moving to the switch!")
            return

        # Step 4: Place the ball on the switch
        print("[Task] Placing the ball on the switch...")
        obs, reward, done = place(env, task, target_pos=switch_pos)
        if done:
            print("[Task] Task ended after placing the ball on the switch!")
            return

        # Step 5: Move to the bin's position
        print("[Task] Moving to the bin's position:", bin_pos)
        obs, reward, done = move(env, task, obs.robot_position, bin_pos)
        if done:
            print("[Task] Task ended after moving to the bin!")
            return

        # Step 6: Drop the ball in the bin
        print("[Task] Dropping the ball in the bin...")
        obs, reward, done = drop(env, task)
        if done:
            print("[Task] Task ended after dropping the ball in the bin!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()