import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import pick, place
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        _, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']
        bin_pos = positions['bin']

        # === Task Plan Execution ===
        # Step 1: Pick item1 from the table
        print("[Task] Picking item1 from the table.")
        obs, reward, done = pick(env, task, item1_pos, approach_distance=0.15)
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 2: Place item1 into the bin
        print("[Task] Placing item1 into the bin.")
        obs, reward, done = place(env, task, bin_pos, approach_distance=0.15)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Step 3: Pick item2 from the table
        print("[Task] Picking item2 from the table.")
        obs, reward, done = pick(env, task, item2_pos, approach_distance=0.15)
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 4: Place item2 into the bin
        print("[Task] Placing item2 into the bin.")
        obs, reward, done = place(env, task, bin_pos, approach_distance=0.15)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

        # Step 5: Pick item3 from the table
        print("[Task] Picking item3 from the table.")
        obs, reward, done = pick(env, task, item3_pos, approach_distance=0.15)
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 6: Place item3 into the bin
        print("[Task] Placing item3 into the bin.")
        obs, reward, done = place(env, task, bin_pos, approach_distance=0.15)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")