def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a target object to pick
        target_object = 'rubbish'  # Example target object
        if target_object not in positions:
            print(f"Error: Target object '{target_object}' not found in object list.")
            return

        target_pos = positions[target_object]
        robot_location = 'room1'  # Example initial robot location

        # Move to the target object's location
        print(f"[Task] Moving to {target_object} at: {target_pos}")
        obs, reward, done = move(env, robot_location, target_pos)
        if done:
            print("[Task] Task ended after moving to target location!")
            return

        # Attempt to pick the target object
        print(f"[Task] Attempting to pick {target_object}.")
        obs, reward, done = pick(env, task, target_pos)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Assuming we need to place the object somewhere
        place_location = 'room2'  # Example location to place the object
        print(f"[Task] Moving to place {target_object} at: {place_location}")
        obs, reward, done = move(env, target_pos, place_location)
        if done:
            print("[Task] Task ended after moving to place location!")
            return

        # Attempt to place the object
        print(f"[Task] Attempting to place {target_object}.")
        obs, reward, done = place(env, task, target_pos, place_location)
        if done:
            print("[Task] Task ended after placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()