def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a ball and a room in the environment
        ball_pos = positions['ball']
        room_pos = positions['room']

        # Step 1: Move to the room where the ball is located
        print("[Task] Moving to the room...")
        obs, reward, done = move(env, task, from_room='initial_room', to_room='room')
        if done:
            print("[Task] Task ended after moving to the room!")
            return

        # Step 2: Check if the room is dark
        if obs.dark:
            print("[Task] Room is dark, need to turn on the light.")
            # Assuming we have a switch to turn on the light
            switch_pos = positions['switch']
            obs, reward, done = move(env, task, from_room='room', to_room='switch_room')
            if done:
                print("[Task] Task ended after moving to the switch room!")
                return
            obs, reward, done = close_gripper(env, task)
            if done:
                print("[Task] Task ended after closing the gripper!")
                return
            obs, reward, done = press(env, task, switch=switch_pos)
            if done:
                print("[Task] Task ended after pressing the switch!")
                return

        # Step 3: Now pick the ball
        print("[Task] Picking the ball...")
        obs, reward, done = pick(env, task, obj='ball', room='room')
        if done:
            print("[Task] Task ended after picking the ball!")
            return

        # Step 4: Place the ball in a designated location
        print("[Task] Placing the ball...")
        target_pos = positions['target_location']
        obs, reward, done = place(env, task, target_pos=target_pos)
        if done:
            print("[Task] Task ended after placing the ball!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()