def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to press
        rubbish_pos = positions['rubbish']  # Replace with actual object key
        robot_pos = positions['robot']  # Replace with actual robot key

        # Step 1: Move to the rubbish position
        print("[Task] Moving to rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, robot_pos, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish!")
            return

        # Step 2: Check if the rubbish is at the target position
        if obs['at_rubbish']:  # Assuming this is how we check if rubbish is present
            # Step 3: Pick up the rubbish
            print("[Task] Picking up rubbish.")
            obs, reward, done = pick(env, task, 'rubbish', rubbish_pos)
            if done:
                print("[Task] Task ended after picking up rubbish!")
                return

            # Step 4: Move to the disposal location (assuming a disposal location is defined)
            disposal_pos = positions['disposal']  # Replace with actual disposal location key
            print("[Task] Moving to disposal at:", disposal_pos)
            obs, reward, done = move(env, task, rubbish_pos, disposal_pos)
            if done:
                print("[Task] Task ended after moving to disposal!")
                return

            # Step 5: Place the rubbish in the disposal location
            print("[Task] Placing rubbish in disposal.")
            obs, reward, done = place(env, task, 'rubbish', disposal_pos)
            if done:
                print("[Task] Task ended after placing rubbish!")
                return
        else:
            print("[Task] Rubbish not found at the target position!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()