def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper_1'  # Placeholder for the actual gripper object
        drawer = 'drawer_1'     # Placeholder for the actual drawer object
        initial_position = 'initial_room'  # Placeholder for the robot's initial position
        target_position = 'target_room'     # Placeholder for the target position

        # Move to the initial position
        print("[Task] Moving to initial position:", initial_position)
        obs, reward, done = move(env, initial_position, target_position)
        if done:
            print("[Task] Task ended after moving to initial position!")
            return

        # Pick the drawer
        print("[Task] Picking the drawer at position:", positions[drawer])
        obs, reward, done = pick(env, drawer, positions[drawer], gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Rotate the gripper to a specific angle (example)
        target_quat = [0, 0, 0, 1]  # Placeholder for the target quaternion
        print("[Task] Rotating gripper to target orientation.")
        obs, reward, done = rotate(env, task, target_quat)
        if done:
            print("[Task] Task ended after rotating the gripper!")
            return

        # Place the drawer in the target position
        print("[Task] Placing the drawer at position:", positions[drawer])
        obs, reward, done = place(env, drawer, positions[drawer])
        if done:
            print("[Task] Task ended after placing the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()