import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        top_drawer_pos = positions['top_anchor_pos']
        middle_drawer_pos = positions['middle_anchor_pos']
        bottom_drawer_pos = positions['bottom_anchor_pos']
        rubbish_pos = positions['item1']  # Assuming rubbish is to be picked from item1 on the table
        bin_pos = positions['bin']  # Assuming rubbish is to be placed in the bin

        # === Execute the Plan ===
        # Step 1: Pull any available drawer (we'll try the top drawer first)
        print("[Task] Attempting to pull the top drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y', max_steps=100, threshold=0.01, timeout=10.0)
        if done:
            print("[Task] Task ended after pulling the top drawer!")
        else:
            print("[Task] Top drawer is still closed, trying the middle drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y', max_steps=100, threshold=0.01, timeout=10.0)
            if done:
                print("[Task] Task ended after pulling the middle drawer!")
            else:
                print("[Task] Middle drawer is still closed, trying the bottom drawer.")
                obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y', max_steps=100, threshold=0.01, timeout=10.0)
                if done:
                    print("[Task] Task ended after pulling the bottom drawer!")
                else:
                    print("[Task] All drawers are closed, cannot proceed.")
                    return

        # Step 2: If any drawer is open, we can proceed to pick rubbish
        print("[Task] Picking rubbish from the table.")
        obs, reward, done = pick(env, task, target_pos=rubbish_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Task ended after picking rubbish!")
        else:
            print("[Task] Failed to pick rubbish, exiting.")
            return

        # Step 3: Place the rubbish in the bin
        print("[Task] Placing rubbish in the bin.")
        obs, reward, done = place(env, task, target_pos=bin_pos, approach_distance=0.15, max_steps=100, threshold=0.01, approach_axis='z', timeout=10.0)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()