def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if 'rubbish' is in the environment
        if 'rubbish' not in positions:
            print("Error: Object 'rubbish' not found in the environment.")
            return

        rubbish_pos = positions['rubbish']
        trash_can_pos = positions['trash_can']  # Assuming trash can is also in the environment

        # Approach and pick up the rubbish
        print("[Task] Approaching rubbish at:", rubbish_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, obs.gripper_pose[3:7])
        if done:
            print("[Task] Task ended while picking up rubbish!")
            return

        # Move to the trash can
        print("[Task] Moving to trash can at:", trash_can_pos)
        obs, reward, done = move(env, task, rubbish_pos, trash_can_pos)
        if done:
            print("[Task] Task ended while moving to trash can!")
            return

        # Place the rubbish in the trash can
        print("[Task] Placing rubbish in trash can...")
        obs, reward, done = place(env, task, trash_can_pos)
        if done:
            print("[Task] Task ended while placing rubbish!")
            return

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()