def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a rubbish object to pick
        rubbish_pos = positions['rubbish']  # Replace with actual object name
        gripper = 'gripper'  # Assuming a single gripper for simplicity
        current_location = 'current_room'  # Replace with actual current room

        # Step 1: Move to the rubbish location
        print("[Task] Moving to rubbish location:", rubbish_pos)
        obs, reward, done = move(env, current_location, rubbish_pos)
        if done:
            print("[Task] Task ended after moving to rubbish location!")
            return

        # Step 2: Pick the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, gripper)
        if done:
            print("[Task] Task ended after picking up the rubbish!")
            return

        # Step 3: Move to the disposal location
        disposal_pos = positions['disposal']  # Replace with actual disposal location
        print("[Task] Moving to disposal location:", disposal_pos)
        obs, reward, done = move(env, rubbish_pos, disposal_pos)
        if done:
            print("[Task] Task ended after moving to disposal location!")
            return

        # Step 4: Place the rubbish in the disposal location
        print("[Task] Placing the rubbish in the disposal location.")
        obs, reward, done = place(env, 'rubbish', disposal_pos)
        if done:
            print("[Task] Task ended after placing the rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()