def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Check if the object 'rubbish' is present in the object list
        if 'rubbish' not in positions:
            print("Error: Object 'rubbish' not found in object list.")
            return

        rubbish_pos = positions['rubbish']
        print("[Task] Rubbish found at:", rubbish_pos)

        # Approach and pick up the rubbish
        print("[Task] Approaching rubbish...")
        obs, reward, done = move(env, task, obs.gripper_pose[:3], rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, obs.gripper_pose)
        if done:
            print("[Task] Task ended while picking up rubbish!")
            return

        # Move to the disposal location (assuming a predefined position for disposal)
        disposal_pos = np.array([1.0, 0.0, 0.0])  # Example position for disposal
        print("[Task] Moving to disposal location...")
        obs, reward, done = move(env, task, rubbish_pos, disposal_pos)
        if done:
            print("[Task] Task ended while moving to disposal location!")
            return

        # Place the rubbish in the disposal location
        print("[Task] Placing rubbish in disposal...")
        obs, reward, done = place(env, task, disposal_pos)
        if done:
            print("[Task] Task ended while placing rubbish!")
            return

        print("[Task] Task completed successfully!")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()