def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided feedback
        rubbish_pos = positions['rubbish']
        bottom_pos = positions['bottom']
        middle_pos = positions['middle']
        top_pos = positions['top']
        gripper_pos = positions['nowhere-pos']

        # Move to the rubbish position
        print("[Task] Moving to rubbish position:", rubbish_pos)
        obs, reward, done = move(env, gripper_pos, rubbish_pos)
        if done:
            print("[Task] Task ended while moving to rubbish!")
            return

        # Pick up the rubbish
        print("[Task] Picking up the rubbish.")
        obs, reward, done = pick(env, 'rubbish', rubbish_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Move to the bottom position
        print("[Task] Moving to bottom position:", bottom_pos)
        obs, reward, done = move(env, rubbish_pos, bottom_pos)
        if done:
            print("[Task] Task ended while moving to bottom!")
            return

        # Place the rubbish in the bottom position
        print("[Task] Placing rubbish in the bottom position.")
        obs, reward, done = place(env, task, bottom_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

        # Move to the middle position
        print("[Task] Moving to middle position:", middle_pos)
        obs, reward, done = move(env, bottom_pos, middle_pos)
        if done:
            print("[Task] Task ended while moving to middle!")
            return

        # Place the rubbish in the middle position
        print("[Task] Placing rubbish in the middle position.")
        obs, reward, done = place(env, task, middle_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

        # Move to the top position
        print("[Task] Moving to top position:", top_pos)
        obs, reward, done = move(env, middle_pos, top_pos)
        if done:
            print("[Task] Task ended while moving to top!")
            return

        # Place the rubbish in the top position
        print("[Task] Placing rubbish in the top position.")
        obs, reward, done = place(env, task, top_pos)
        if done:
            print("[Task] Task ended after placing rubbish!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()