import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        top_drawer_pos = positions['top_anchor_pos']
        middle_drawer_pos = positions['middle_anchor_pos']
        bottom_drawer_pos = positions['bottom_anchor_pos']
        rubbish_pos = positions['item1']  # Assuming item1 is rubbish
        bin_pos = positions['bin']  # Assuming bin is where rubbish goes

        # === Execute the Plan ===
        # Step 1: Pull open any available drawer
        if not obs.is_open[top_drawer_pos]:
            print("[Task] Opening top drawer...")
            obs, reward, done = pull(env, task, top_drawer_pos)
            if done:
                print("[Task] Task ended after pulling top drawer!")
                return
        
        elif not obs.is_open[middle_drawer_pos]:
            print("[Task] Opening middle drawer...")
            obs, reward, done = pull(env, task, middle_drawer_pos)
            if done:
                print("[Task] Task ended after pulling middle drawer!")
                return
        
        elif not obs.is_open[bottom_drawer_pos]:
            print("[Task] Opening bottom drawer...")
            obs, reward, done = pull(env, task, bottom_drawer_pos)
            if done:
                print("[Task] Task ended after pulling bottom drawer!")
                return

        # Step 2: Pick up rubbish from the table
        print("[Task] Picking up rubbish...")
        obs, reward, done = pick(env, task, rubbish_pos, positions['table'])
        if done:
            print("[Task] Task ended after picking up rubbish!")
            return

        # Step 3: Place rubbish in the bin
        print("[Task] Placing rubbish in the bin...")
        obs, reward, done = place(env, task, rubbish_pos, bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()