def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer to interact with
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'     # Placeholder for the actual drawer object
        object_to_pick = 'object'  # Placeholder for the object to pick

        # Step 1: Move to the drawer's position
        print("[Task] Moving to the drawer's position.")
        obs, reward, done = move(env, 'initial_position', 'drawer_position')
        if done:
            print("[Task] Task ended while moving to the drawer!")
            return

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, 'drawer_position', gripper)
        if done:
            print("[Task] Task ended while picking the drawer!")
            return

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        obs, reward, done = pull(env, task, pull_distance=0.1)
        if done:
            print("[Task] Task ended while pulling the drawer!")
            return

        # Step 4: Move to the object position
        print("[Task] Moving to the object position.")
        obs, reward, done = move(env, 'drawer_position', 'object_position')
        if done:
            print("[Task] Task ended while moving to the object!")
            return

        # Step 5: Pick the object
        print("[Task] Picking the object.")
        obs, reward, done = pick(env, object_to_pick, 'object_position', gripper)
        if done:
            print("[Task] Task ended while picking the object!")
            return

        # Step 6: Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, object_to_pick, 'drawer_position')
        if done:
            print("[Task] Task ended while placing the object!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()