def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a drawer and a gripper
        gripper = 'gripper'
        drawer = 'drawer'
        bottom_position = positions['bottom_position']  # Replace with actual position key
        anchor_position = positions['anchor_position']  # Replace with actual position key

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        move(env, gripper, bottom_position, anchor_position)

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick(env, gripper, drawer, anchor_position)

        # Step 3: Pull the drawer open
        print("[Task] Pulling the drawer open.")
        pull(env, gripper, drawer)

        # Step 4: Place the drawer back
        print("[Task] Placing the drawer back.")
        place(env, drawer, bottom_position)

    except Exception as e:
        print(f"An error occurred: {e}")
    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()