def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        gripper = 'gripper'
        drawer = 'drawer'
        side_pos_bottom = 'side-pos-bottom'
        anchor_pos = 'anchor-pos'
        object_to_pick = 'object'  # Replace with actual object name

        # Step 1: Move to the side position of the drawer
        print("[Task] Moving to side position of the drawer.")
        move(env, gripper, positions[gripper], positions[side_pos_bottom])

        # Step 2: Pick the drawer
        print("[Task] Picking the drawer.")
        pick_drawing(env, gripper, drawer, side_pos_bottom)

        # Step 3: Pull the drawer
        print("[Task] Pulling the drawer.")
        pull(env, gripper, drawer)

        # Step 4: Move to the anchor position of the drawer
        print("[Task] Moving to anchor position of the drawer.")
        move(env, gripper, side_pos_bottom, anchor_pos)

        # Step 5: Place the object in the drawer
        print("[Task] Placing the object in the drawer.")
        place(env, object_to_pick, positions[drawer])

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()