import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        bottom_anchor_pos = positions['bottom_anchor_pos']
        middle_anchor_pos = positions['middle_anchor_pos']
        top_anchor_pos = positions['top_anchor_pos']
        bin_pos = positions['bin']

        # === Execute the Plan ===
        # Step 1: Pull open any drawer that is not locked
        # Check if the top drawer is locked
        if not obs.is_locked['top']:
            print("[Task] Pulling open the top drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the top drawer!")
                return

        # Check if the middle drawer is locked
        if not obs.is_locked['middle']:
            print("[Task] Pulling open the middle drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the middle drawer!")
                return

        # Check if the bottom drawer is locked
        if not obs.is_locked['bottom']:
            print("[Task] Pulling open the bottom drawer.")
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
            if done:
                print("[Task] Task ended after pulling the bottom drawer!")
                return

        # Step 2: Drop the rubbish into the bin
        print("[Task] Placing the rubbish into the bin.")
        obs, reward, done = place(env, task, target_pos=bin_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()