import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment
from skill_code import *  # Importing predefined skills
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions based on the provided object list
        rubbish_pos = positions['rubbish']
        bin_pos = positions['bin']
        top_pos = positions['top_side_pos']  # Assuming we want to pull the top drawer

        # === Execute the Plan ===
        # Step 1: Pull open any drawer that is not locked
        try:
            # Move to the top drawer's side position
            obs, reward, done = move(env, task, target_pos=top_pos)
            if done:
                print("[Task] Task ended during move to top drawer!")
                return
            
            # Pick the top drawer
            obs, reward, done = pick(env, task, target_pos=top_pos)
            if done:
                print("[Task] Task ended during pick of top drawer!")
                return
            
            # Pull the top drawer
            obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')  # Adjust pull distance as needed
            if done:
                print("[Task] Task ended during pull of top drawer!")
                return
            
        except Exception as e:
            print(f"[Error] An error occurred during pulling: {e}")

        # Step 2: Drop the rubbish into the bin
        try:
            # Move to the rubbish position
            obs, reward, done = move(env, task, target_pos=rubbish_pos)
            if done:
                print("[Task] Task ended during move to rubbish!")
                return
            
            # Pick the rubbish
            obs, reward, done = pick(env, task, target_pos=rubbish_pos)
            if done:
                print("[Task] Task ended during pick of rubbish!")
                return
            
            # Move to the bin position
            obs, reward, done = move(env, task, target_pos=bin_pos)
            if done:
                print("[Task] Task ended during move to bin!")
                return
            
            # Place the rubbish in the bin
            obs, reward, done = place(env, task, target_pos=bin_pos)
            if done:
                print("[Task] Task completed successfully! Rubbish placed in bin.")
            else:
                print("[Task] Task not completed yet (done=False).")
        
        except Exception as e:
            print(f"[Error] An error occurred during placing: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()