def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named item1, item2, item3 in the environment
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        item3_pos = positions['item3']

        # Step 1: Move to item1's position
        print("[Task] Moving to item1 at:", item1_pos)
        obs, reward, done = move(env, 'room_a', item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1")
        obs, reward, done = pick(env, 'item1', item1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to item2's position
        print("[Task] Moving to item2 at:", item2_pos)
        obs, reward, done = move(env, item1_pos, item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 4: Place item1 at item2's position
        print("[Task] Placing item1 at item2's position")
        obs, reward, done = place(env, 'item1', item2_pos)
        if done:
            print("[Task] Task ended after placing item1!")
            return

        # Step 5: Move to item3's position
        print("[Task] Moving to item3 at:", item3_pos)
        obs, reward, done = move(env, item2_pos, item3_pos)
        if done:
            print("[Task] Task ended after moving to item3!")
            return

        # Step 6: Pick item3
        print("[Task] Picking item3")
        obs, reward, done = pick(env, 'item3', item3_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item3!")
            return

        # Step 7: Place item3 at item1's original position
        print("[Task] Placing item3 at item1's original position")
        obs, reward, done = place(env, 'item3', item1_pos)
        if done:
            print("[Task] Task ended after placing item3!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()