import numpy as np
from pyrep.objects.shape import Shape
from pyrep.objects.proximity_sensor import ProximitySensor

from env import setup_environment, shutdown_environment

from skill_code import *
from video import init_video_writers, recording_step, recording_get_observation
from object_positions import get_object_positions

def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Define object positions
        bottom_anchor_pos = positions['bottom_anchor_pos']
        bottom_side_pos = positions['bottom_side_pos']
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        plate_pos = positions['plate']

        # === Execute the Plan ===
        # Step 1: Pull open the bottom drawer
        print("[Task] Pulling open the bottom drawer...")
        obs, reward, done = pull(env, task, pull_distance=0.1, pull_axis='y')
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 2: Pick the first tomato (item1) from the table
        print("[Task] Picking up the first tomato...")
        obs, reward, done = pick(env, task, target_pos=item1_pos)
        if done:
            print("[Task] Task ended after picking the first tomato!")
            return

        # Step 3: Place the first tomato onto the plate
        print("[Task] Placing the first tomato onto the plate...")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task ended after placing the first tomato!")
            return

        # Step 4: Pick the second tomato (item2) from the table
        print("[Task] Picking up the second tomato...")
        obs, reward, done = pick(env, task, target_pos=item2_pos)
        if done:
            print("[Task] Task ended after picking the second tomato!")
            return

        # Step 5: Place the second tomato onto the plate
        print("[Task] Placing the second tomato onto the plate...")
        obs, reward, done = place(env, task, target_pos=plate_pos)
        if done:
            print("[Task] Task completed successfully! Reward:", reward)
        else:
            print("[Task] Task not completed yet (done=False).")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")

if __name__ == "__main__":
    run_skeleton_task()