def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a gripper and a drawer in the environment
        gripper = 'gripper'  # Placeholder for the actual gripper object
        drawer = 'drawer'  # Placeholder for the actual drawer object
        target_pos = positions[drawer]  # Get the position of the drawer

        # Safety check: Ensure the gripper is not locked
        if is_gripper_locked(env):
            print("Error: Gripper is locked!")
            return

        # Step 1: Move to the drawer's position
        print(f"[Task] Moving to the drawer at: {target_pos}")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], target_pos)
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 2: Pick the drawer
        print(f"[Task] Picking the drawer.")
        obs, reward, done = pick(env, drawer, target_pos, gripper)
        if done:
            print("[Task] Task ended after picking the drawer!")
            return

        # Step 3: Open the drawer
        print(f"[Task] Pulling the drawer to open it.")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after pulling the drawer!")
            return

        # Step 4: Place an object in the drawer (assuming we have an object to place)
        object_to_place = 'object'  # Placeholder for the actual object
        object_pos = positions[object_to_place]  # Get the position of the object

        # Move to the object's position
        print(f"[Task] Moving to the object at: {object_pos}")
        obs, reward, done = move(env, gripper, obs.gripper_pose[:3], object_pos)
        if done:
            print("[Task] Task ended after moving to the object!")
            return

        # Pick the object
        print(f"[Task] Picking the object.")
        obs, reward, done = pick(env, object_to_place, object_pos, gripper)
        if done:
            print("[Task] Task ended after picking the object!")
            return

        # Step 5: Place the object in the drawer
        print(f"[Task] Placing the object in the drawer.")
        obs, reward, done = place(env, task, target_pos)
        if done:
            print("[Task] Task ended after placing the object in the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()