def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have objects named 'item1', 'item2', and 'drawer1'
        item1_pos = positions['item1']
        item2_pos = positions['item2']
        drawer1_pos = positions['drawer1']

        # Step 1: Move to item1's position
        print("[Task] Moving to item1's position:", item1_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], item1_pos)
        if done:
            print("[Task] Task ended after moving to item1!")
            return

        # Step 2: Pick item1
        print("[Task] Picking item1...")
        obs, reward, done = pick(env, 'item1', item1_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item1!")
            return

        # Step 3: Move to drawer1's position
        print("[Task] Moving to drawer1's position:", drawer1_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], drawer1_pos)
        if done:
            print("[Task] Task ended after moving to drawer1!")
            return

        # Step 4: Place item1 in drawer1
        print("[Task] Placing item1 in drawer1...")
        obs, reward, done = place(env, task, drawer1_pos)
        if done:
            print("[Task] Task ended after placing item1 in drawer1!")
            return

        # Step 5: Move to item2's position
        print("[Task] Moving to item2's position:", item2_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], item2_pos)
        if done:
            print("[Task] Task ended after moving to item2!")
            return

        # Step 6: Pick item2
        print("[Task] Picking item2...")
        obs, reward, done = pick(env, 'item2', item2_pos, 'gripper')
        if done:
            print("[Task] Task ended after picking item2!")
            return

        # Step 7: Move back to drawer1's position
        print("[Task] Moving back to drawer1's position:", drawer1_pos)
        obs, reward, done = move(env, task, obs.gripper_pose[:3], drawer1_pos)
        if done:
            print("[Task] Task ended after moving back to drawer1!")
            return

        # Step 8: Place item2 in drawer1
        print("[Task] Placing item2 in drawer1...")
        obs, reward, done = place(env, task, drawer1_pos)
        if done:
            print("[Task] Task ended after placing item2 in drawer1!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")