def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have a list of objects to manipulate
        object_list = list(positions.keys())

        # Example task plan
        # 1) Approach and manipulate object_1
        object_1_pos = positions['object_1']
        print("[Task] Manipulating object_1 at:", object_1_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_1_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0,
            force_calibration=True,
            object_list=object_list
        )
        if done:
            print("[Task] Task ended after manipulating object_1!")
            return

        # 2) Place object_1 in a new location
        new_location = positions['new_location']
        print("[Task] Placing object_1 at:", new_location)
        obs, reward, done = place(
            env,
            task,
            target_pos=new_location
        )
        if done:
            print("[Task] Task ended after placing object_1!")
            return

        # 3) Approach and manipulate object_2
        object_2_pos = positions['object_2']
        print("[Task] Manipulating object_2 at:", object_2_pos)
        obs, reward, done = pick(
            env,
            task,
            target_pos=object_2_pos,
            approach_distance=0.15,
            max_steps=100,
            threshold=0.01,
            approach_axis='z',
            timeout=10.0,
            force_calibration=True,
            object_list=object_list
        )
        if done:
            print("[Task] Task ended after manipulating object_2!")
            return

        # 4) Place object_2 in a new location
        new_location_2 = positions['new_location_2']
        print("[Task] Placing object_2 at:", new_location_2)
        obs, reward, done = place(
            env,
            task,
            target_pos=new_location_2
        )
        if done:
            print("[Task] Task ended after placing object_2!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()