def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        tomato_pos = positions['tomato']
        drawer_pos = positions['drawer']
        gripper = 'gripper'  # Assuming a single gripper for simplicity

        # Step 1: Move to the tomato
        print("[Task] Moving to tomato at:", tomato_pos)
        obs, reward, done = move(env, 'room_a', 'room_b')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to tomato!")
            return

        # Step 2: Pick the tomato
        print("[Task] Picking up the tomato.")
        obs, reward, done = pick(env, 'tomato', 'room_b', gripper)
        if done:
            print("[Task] Task ended after picking the tomato!")
            return

        # Step 3: Move to the drawer
        print("[Task] Moving to the drawer at:", drawer_pos)
        obs, reward, done = move(env, 'room_b', 'room_c')  # Replace with actual room names
        if done:
            print("[Task] Task ended after moving to drawer!")
            return

        # Step 4: Open the drawer
        print("[Task] Opening the drawer.")
        obs, reward, done = pull(env, gripper, 'drawer')
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

        # Step 5: Place the tomato in the drawer
        print("[Task] Placing the tomato in the drawer.")
        obs, reward, done = place(env, task, target_pos=drawer_pos)
        if done:
            print("[Task] Task ended after placing the tomato!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()