def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these placeholder keys with your actual objects
        object_1_pos = positions['object_1']  # Example object position
        object_2_pos = positions['object_2']  # Example object position
        gripper = 'gripper'  # Assuming a gripper object is available
        drawer = 'drawer'  # Assuming a drawer object is available

        # Step 1: Move to the position of object_1
        print("[Task] Moving to object_1 at:", object_1_pos)
        obs, reward, done = move(env, 'initial_room', object_1_pos)
        if done:
            print("[Task] Task ended after moving to object_1!")
            return

        # Step 2: Pick object_1
        print("[Task] Picking object_1")
        obs, reward, done = pick(env, 'object_1', object_1_pos, gripper)
        if done:
            print("[Task] Task ended after picking object_1!")
            return

        # Step 3: Move to the drawer position
        print("[Task] Moving to the drawer")
        obs, reward, done = move(env, object_1_pos, 'drawer_position')
        if done:
            print("[Task] Task ended after moving to the drawer!")
            return

        # Step 4: Place object_1 in the drawer
        print("[Task] Placing object_1 in the drawer")
        obs, reward, done = place(env, 'object_1', 'drawer_position')
        if done:
            print("[Task] Task ended after placing object_1 in the drawer!")
            return

        # Step 5: Open the drawer
        print("[Task] Opening the drawer")
        obs, reward, done = pull(env, gripper, drawer)
        if done:
            print("[Task] Task ended after opening the drawer!")
            return

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()