def run_skeleton_task():
    '''Generic skeleton for running any task in your simulation.'''
    print("===== Starting Skeleton Task =====")
    
    # === Environment Setup ===
    env, task = setup_environment()
    try:
        # Reset the task to its initial state
        descriptions, obs = task.reset()

        # (Optional) Initialize video writers for capturing your simulation
        init_video_writers(obs)

        # Wrap the task steps for recording (if needed)
        original_step = task.step
        task.step = recording_step(original_step)
        original_get_obs = task.get_observation
        task.get_observation = recording_get_observation(original_get_obs)

        # === Retrieve Object Positions ===
        positions = get_object_positions()

        # Assuming we have the following objects in the environment
        # Replace these with actual object names from your environment
        drawer = 'drawer1'
        gripper = 'gripper1'
        object1 = 'object1'  # The object to pick
        object2 = 'object2'  # The object to place

        # Example positions (replace with actual positions from `positions`)
        drawer_position = positions[drawer]
        object1_position = positions[object1]
        object2_position = positions[object2]

        # Step 1: Move to the object1 position
        print("[Task] Moving to object1 position:", object1_position)
        move(env, 'current_room', object1_position)

        # Step 2: Pick object1
        print("[Task] Picking object1")
        pick(env, object1, 'current_room', gripper)

        # Step 3: Move to the drawer position
        print("[Task] Moving to drawer position:", drawer_position)
        move(env, 'current_room', drawer_position)

        # Step 4: Place object1 in the drawer
        print("[Task] Placing object1 in the drawer")
        place(env, object1, drawer_position)

        # Step 5: Open the drawer
        print("[Task] Opening the drawer")
        rotate(env, gripper, 'current_angle', 'ninety_deg')
        move_to_side(env, gripper, drawer, 'current_position', 'side_position')
        pull(env, gripper, drawer)

        # Step 6: Move to object2 position
        print("[Task] Moving to object2 position:", object2_position)
        move(env, 'current_room', object2_position)

        # Step 7: Pick object2
        print("[Task] Picking object2")
        pick(env, object2, 'current_room', gripper)

        # Step 8: Move back to the drawer position
        print("[Task] Moving back to drawer position")
        move(env, 'current_room', drawer_position)

        # Step 9: Place object2 in the drawer
        print("[Task] Placing object2 in the drawer")
        place(env, object2, drawer_position)

        print("[Task] Task completed successfully!")

    except Exception as e:
        print(f"[Error] An error occurred: {e}")

    finally:
        # Always ensure the environment is properly shutdown
        shutdown_environment(env)

    print("===== End of Skeleton Task =====")


if __name__ == "__main__":
    run_skeleton_task()